<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notificacao_cobranca_historico', function (Blueprint $table) {
            $table->id();
            $table->foreignId('notificacao_cobranca_id')->constrained('notificacoes_cobrancas')->onDelete('cascade');
            $table->foreignId('empresa_id')->constrained('empresas')->onDelete('cascade');
            $table->tinyInteger('status')->default(0); // 0 = Pendente, 1 = Enviado, 2 = Erro, 3 = Pago
            $table->text('pix_copia_cola')->nullable();
            $table->text('mensagem')->nullable();
            $table->string('externo_id', 250)->nullable();
            $table->string('gateway', 50)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notificacao_cobranca_historico');
    }
};
