@extends('layouts.app', ['title' => 'Consignados'])
@section('content')

<div class="card card-custom gutter-b">
    <div class="card-header flex-wrap border-0 pt-6 pb-0">
        <div class="card-title">
            <h3 class="card-label">
                {{ $titulo }}
                <small>Lista de consignações</small>
            </h3>
        </div>
        <div class="card-toolbar">
            <a href="{{ route('consignments.create') }}" class="btn btn-success">
                <i class="la la-plus"></i>Nova Consignação
            </a>
        </div>
    </div>

    <div class="card-body">
        <div class="row align-items-center">
            <div class="form">
                <form method="get" action="{{ route('consignments.index') }}">
                    <div class="row">
                        <div class="col-lg-3 col-md-4 col-sm-6">
                            <div class="form-group">
                                <label class="col-form-label">Cliente</label>
                                <div class="">
                                    <select name="cliente_id" class="form-control select2">
                                        <option value="">Todos</option>
                                        @foreach($clientes as $cliente)
                                        <option value="{{$cliente->id}}" {{ (isset($_GET['cliente_id']) && $_GET['cliente_id'] == $cliente->id) ? 'selected' : '' }}>{{$cliente->razao_social}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-4 col-sm-6">
                            <div class="form-group">
                                <label class="col-form-label">Status</label>
                                <div class="">
                                    <select name="status" class="form-control select2">
                                        <option value="">Todos</option>
                                        <option value="aberto" {{ (isset($_GET['status']) && $_GET['status'] == 'aberto') ? 'selected' : '' }}>Aberto</option>
                                        <option value="concluido" {{ (isset($_GET['status']) && $_GET['status'] == 'concluido') ? 'selected' : '' }}>Concluído</option>
                                        <option value="cancelado" {{ (isset($_GET['status']) && $_GET['status'] == 'cancelado') ? 'selected' : '' }}>Cancelado</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-4 col-sm-6">
                            <div class="form-group">
                                <label class="col-form-label">Data Inicial</label>
                                <div class="">
                                    <div class="input-group date">
                                        <input type="text" name="data_inicio" class="form-control" readonly value="{{ isset($_GET['data_inicio']) ? $_GET['data_inicio'] : '' }}" id="kt_datepicker_3" />
                                        <div class="input-group-append">
                                            <span class="input-group-text">
                                                <i class="la la-calendar"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-4 col-sm-6">
                            <div class="form-group">
                                <label class="col-form-label">Data Final</label>
                                <div class="">
                                    <div class="input-group date">
                                        <input type="text" name="data_fim" class="form-control" readonly value="{{ isset($_GET['data_fim']) ? $_GET['data_fim'] : '' }}" id="kt_datepicker_3" />
                                        <div class="input-group-append">
                                            <span class="input-group-text">
                                                <i class="la la-calendar"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-4 col-sm-6">
                            <div class="form-group">
                                <label class="col-form-label">&nbsp;</label>
                                <div class="">
                                    <button type="submit" class="btn btn-light-primary">
                                        <i class="la la-search"></i>
                                        Filtrar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <br>
        <div class="row">
            <div class="col-12">
                <div class="table-responsive">
                    <table class="table table-hover table-striped" id="kt_datatable">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Cliente</th>
                                <th>Data Abertura</th>
                                <th>Data Fechamento</th>
                                <th>Status</th>
                                <th>Produtos</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($consignments as $consignment)
                            <tr>
                                <td>{{ $consignment->id }}</td>
                                <td>{{ $consignment->cliente->razao_social }}</td>
                                <td>{{ \Carbon\Carbon::parse($consignment->data_abertura)->format('d/m/Y') }}</td>
                                <td>
                                    @if($consignment->data_fechamento)
                                        {{ \Carbon\Carbon::parse($consignment->data_fechamento)->format('d/m/Y') }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td>
                                    <span class="label label-{{ $consignment->status_class }} label-xl label-dot mr-2"></span>
                                    <span class="font-weight-bold text-{{ $consignment->status_class }}">
                                        {{ $consignment->status_texto }}
                                    </span>
                                </td>
                                <td>{{ $consignment->items->count() }}</td>
                                <td>
                                    <div class="dropdown dropdown-inline">
                                        <button type="button" class="btn btn-sm btn-clean btn-icon mr-2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <span class="svg-icon svg-icon-md">
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                        <rect x="0" y="0" width="24" height="24"/>
                                                        <path d="M5,8.6862915 L5,5 L8.6862915,5 L11.5857864,2.10050506 L14.4852814,5 L19,5 L19,9.51471863 L21.4852814,12 L19,14.4852814 L19,19 L14.4852814,19 L11.5857864,21.8994949 L8.6862915,19 L5,19 L5,15.3137085 L1.6862915,12 L5,8.6862915 Z M12,15 C13.6568542,15 15,13.6568542 15,12 C15,10.3431458 13.6568542,9 12,9 C10.3431458,9 9,10.3431458 9,12 C9,13.6568542 10.3431458,15 12,15 Z" fill="#000000"/>
                                                    </g>
                                                </svg>
                                            </span>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-sm dropdown-menu-right">
                                            <ul class="navi flex-column navi-hover py-2">
                                                <li class="navi-header font-weight-bolder text-uppercase font-size-xs text-primary pb-2">
                                                    Selecione uma ação:
                                                </li>
                                                <li class="navi-item">
                                                    <a href="{{ route('consignments.show', $consignment->id) }}" class="navi-link">
                                                        <span class="navi-icon"><i class="la la-eye"></i></span>
                                                        <span class="navi-text">Visualizar</span>
                                                    </a>
                                                </li>
                                                
                                                @if($consignment->status == 'aberto')
                                                <li class="navi-item">
                                                    <a href="{{ route('consignments.edit', $consignment->id) }}" class="navi-link">
                                                        <span class="navi-icon"><i class="la la-edit"></i></span>
                                                        <span class="navi-text">Editar</span>
                                                    </a>
                                                </li>
                                                <li class="navi-item">
                                                    <a href="{{ route('consignments.finalize', $consignment->id) }}" class="navi-link">
                                                        <span class="navi-icon"><i class="la la-check-square"></i></span>
                                                        <span class="navi-text">Finalizar</span>
                                                    </a>
                                                </li>
                                                <li class="navi-item">
                                                    <a href="javascript:;" onclick="document.getElementById('form-cancel-{{ $consignment->id }}').submit()" class="navi-link">
                                                        <span class="navi-icon"><i class="la la-times-circle"></i></span>
                                                        <span class="navi-text">Cancelar</span>
                                                    </a>
                                                    <form method="post" action="{{ route('consignments.cancel', $consignment->id) }}" id="form-cancel-{{ $consignment->id }}">
                                                        @csrf
                                                    </form>
                                                </li>
                                                @endif
                                            </ul>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <div class="d-flex justify-content-center">
                        {{ $consignments->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@section('javascript')
<script type="text/javascript">
    $(function () {
        $('.select2').select2();
        
        $('#kt_datepicker_3').datepicker({
            todayBtn: "linked",
            clearBtn: true,
            todayHighlight: true,
            format: 'dd/mm/yyyy',
            orientation: "bottom left",
            templates: {
                leftArrow: '<i class="la la-angle-left"></i>',
                rightArrow: '<i class="la la-angle-right"></i>'
            }
        });
    });
</script>
@endsection

@endsection
