@extends('layouts.app', ['title' => 'Finalizar Consignação'])
@section('content')

<div class="card card-custom gutter-b">
    <div class="card-header flex-wrap border-0 pt-6 pb-0">
        <div class="card-title">
            <h3 class="card-label">
                {{ $titulo }}
                <small>Consignação #{{ $consignment->id }}</small>
            </h3>
        </div>
        <div class="card-toolbar">
            <a href="{{ route('consignments.show', $consignment->id) }}" class="btn btn-secondary">
                <i class="la la-angle-left"></i>Voltar
            </a>
        </div>
    </div>

    <div class="card-body">
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-12">
                <div class="form-group row">
                    <label class="col-4 col-form-label font-weight-bold">Cliente:</label>
                    <div class="col-8">
                        <span class="form-control-plaintext">{{ $consignment->cliente->razao_social }}</span>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-4 col-form-label font-weight-bold">Telefone:</label>
                    <div class="col-8">
                        <span class="form-control-plaintext">{{ $consignment->cliente->telefone ?? '-' }}</span>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-4 col-form-label font-weight-bold">Email:</label>
                    <div class="col-8">
                        <span class="form-control-plaintext">{{ $consignment->cliente->email ?? '-' }}</span>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-12">
                <div class="form-group row">
                    <label class="col-4 col-form-label font-weight-bold">Status:</label>
                    <div class="col-8">
                        <span class="label label-{{ $consignment->status_class }} label-lg">
                            {{ $consignment->status_texto }}
                        </span>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-4 col-form-label font-weight-bold">Data Abertura:</label>
                    <div class="col-8">
                        <span class="form-control-plaintext">{{ \Carbon\Carbon::parse($consignment->data_abertura)->format('d/m/Y') }}</span>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="separator separator-dashed my-5"></div>
        
        <div class="row mb-3">
            <div class="col-lg-12">
                <h4>Finalizar Consignação</h4>
                <p>Informe abaixo quais produtos serão devolvidos e quais serão faturados. Os produtos não devolvidos serão convertidos em uma venda.</p>
            </div>
        </div>
        
        <form action="{{ route('consignments.finalize-process', $consignment->id) }}" method="POST" id="form-finalize">
            @csrf
            
            <div class="row">
                <div class="col-lg-12">
                    <div class="table-responsive">
                        <table class="table table-hover table-striped">
                            <thead>
                                <tr>
                                    <th>Produto</th>
                                    <th>Valor Unitário</th>
                                    <th>Qtd. Consignada</th>
                                    <th width="200">Qtd. Devolvida</th>
                                    <th>Qtd. Vendida</th>
                                    <th>Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($consignment->items as $item)
                                <tr>
                                    <td>
                                        {{ $item->produto->nome }}
                                        @if($item->produtoVariacao)
                                            - {{ $item->produtoVariacao->descricao }}
                                        @endif
                                    </td>
                                    <td>R$ {{ number_format($item->valor_unitario, 2, ',', '.') }}</td>
                                    <td>
                                        <span class="quantidade-consignada">{{ number_format($item->quantidade_consignada, 3, ',', '.') }}</span>
                                        <input type="hidden" class="quantidade-total" value="{{ $item->quantidade_consignada }}">
                                    </td>
                                    <td>
                                        <input 
                                            type="number" 
                                            class="form-control quantidade-devolvida" 
                                            name="items[{{ $item->id }}][quantidade_devolvida]" 
                                            value="0" 
                                            min="0" 
                                            max="{{ $item->quantidade_consignada }}" 
                                            step="0.001"
                                            data-item-id="{{ $item->id }}"
                                            data-valor="{{ $item->valor_unitario }}"
                                        >
                                    </td>
                                    <td>
                                        <span class="quantidade-vendida" id="vendida-{{ $item->id }}">{{ number_format($item->quantidade_consignada, 3, ',', '.') }}</span>
                                    </td>
                                    <td>
                                        <span class="subtotal" id="subtotal-{{ $item->id }}">R$ {{ number_format($item->quantidade_consignada * $item->valor_unitario, 2, ',', '.') }}</span>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="5" class="text-right"><strong>Total:</strong></td>
                                    <td><strong id="total-venda">R$ {{ number_format($consignment->items->sum(function($item) { return $item->quantidade_consignada * $item->valor_unitario; }), 2, ',', '.') }}</strong></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
            
            <div class="row mt-5">
                <div class="col-lg-12 text-right">
                    <button type="submit" class="btn btn-success btn-lg">
                        <i class="la la-check"></i>
                        Finalizar Consignação e Gerar Venda
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

@section('javascript')
<script type="text/javascript">
    $(function () {
        // Calcular quantidade vendida e subtotal ao alterar quantidade devolvida
        $('.quantidade-devolvida').on('input', function() {
            const itemId = $(this).data('item-id');
            const valor = parseFloat($(this).data('valor'));
            const quantidadeTotal = parseFloat($(this).closest('tr').find('.quantidade-total').val());
            let quantidadeDevolvida = parseFloat($(this).val()) || 0;
            
            // Garantir que a quantidade devolvida não seja maior que a total
            if (quantidadeDevolvida > quantidadeTotal) {
                quantidadeDevolvida = quantidadeTotal;
                $(this).val(quantidadeTotal);
            }
            
            const quantidadeVendida = quantidadeTotal - quantidadeDevolvida;
            const subtotal = quantidadeVendida * valor;
            
            // Atualizar os campos
            $(`#vendida-${itemId}`).text(formatNumber(quantidadeVendida));
            $(`#subtotal-${itemId}`).text('R$ ' + formatMoney(subtotal));
            
            // Recalcular o total
            calcularTotal();
        });
        
        // Recalcular o total inicial
        calcularTotal();
        
        // Validar o formulário antes de enviar
        $('#form-finalize').submit(function(e) {
            const total = calcularTotalRaw();
            
            if (total <= 0) {
                if (!confirm('Todos os produtos serão devolvidos ao estoque. Nenhuma venda será gerada. Deseja continuar?')) {
                    e.preventDefault();
                    return false;
                }
            }
            
            return true;
        });
    });
    
    function calcularTotal() {
        const total = calcularTotalRaw();
        $('#total-venda').text('R$ ' + formatMoney(total));
    }
    
    function calcularTotalRaw() {
        let total = 0;
        
        $('.quantidade-devolvida').each(function() {
            const valor = parseFloat($(this).data('valor'));
            const quantidadeTotal = parseFloat($(this).closest('tr').find('.quantidade-total').val());
            const quantidadeDevolvida = parseFloat($(this).val()) || 0;
            const quantidadeVendida = quantidadeTotal - quantidadeDevolvida;
            
            total += quantidadeVendida * valor;
        });
        
        return total;
    }
    
    function formatNumber(value) {
        return parseFloat(value).toFixed(3).replace('.', ',');
    }
    
    function formatMoney(value) {
        return parseFloat(value).toFixed(2).replace('.', ',');
    }
</script>
@endsection

@endsection
