@extends('layouts.app', ['title' => 'Editar Consignação'])
@section('content')

<div class="card card-custom gutter-b">
    <div class="card-header flex-wrap border-0 pt-6 pb-0">
        <div class="card-title">
            <h3 class="card-label">
                {{ $titulo }}
                <small>Consignação #{{ $consignment->id }}</small>
            </h3>
        </div>
        <div class="card-toolbar">
            <a href="{{ route('consignments.show', $consignment->id) }}" class="btn btn-secondary">
                <i class="la la-angle-left"></i>Voltar
            </a>
        </div>
    </div>

    <div class="card-body">
        <form action="{{ route('consignments.update', $consignment->id) }}" method="post">
            @csrf
            @method('PUT')
            
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <div class="form-group row">
                        <label class="col-4 col-form-label font-weight-bold">Cliente:</label>
                        <div class="col-8">
                            <span class="form-control-plaintext">{{ $consignment->cliente->razao_social }}</span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-4 col-form-label font-weight-bold">Telefone:</label>
                        <div class="col-8">
                            <span class="form-control-plaintext">{{ $consignment->cliente->telefone ?? '-' }}</span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-4 col-form-label font-weight-bold">Email:</label>
                        <div class="col-8">
                            <span class="form-control-plaintext">{{ $consignment->cliente->email ?? '-' }}</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <div class="form-group row">
                        <label class="col-4 col-form-label font-weight-bold">Status:</label>
                        <div class="col-8">
                            <span class="label label-{{ $consignment->status_class }} label-lg">
                                {{ $consignment->status_texto }}
                            </span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-4 col-form-label font-weight-bold">Data Abertura:</label>
                        <div class="col-8">
                            <span class="form-control-plaintext">{{ \Carbon\Carbon::parse($consignment->data_abertura)->format('d/m/Y') }}</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-lg-12">
                    <div class="form-group">
                        <label class="font-weight-bold">Observação:</label>
                        <textarea name="observacao" class="form-control" rows="3">{{ $consignment->observacao }}</textarea>
                    </div>
                </div>
            </div>
            
            <div class="separator separator-dashed my-5"></div>
            
            <div class="row mb-5">
                <div class="col-lg-12">
                    <h4>Produtos Consignados</h4>
                </div>
            </div>
            
            <div class="row">
                <div class="col-lg-12">
                    <div class="table-responsive">
                        <table class="table table-hover table-striped">
                            <thead>
                                <tr>
                                    <th>Produto</th>
                                    <th>Valor Unitário</th>
                                    <th>Qtd. Consignada</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($consignment->items as $item)
                                <tr>
                                    <td>
                                        {{ $item->produto->nome }}
                                        @if($item->produtoVariacao)
                                            - {{ $item->produtoVariacao->descricao }}
                                        @endif
                                    </td>
                                    <td>R$ {{ number_format($item->valor_unitario, 2, ',', '.') }}</td>
                                    <td>{{ number_format($item->quantidade_consignada, 3, ',', '.') }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="2" class="text-right"><strong>Valor Total (produtos vendidos):</strong></td>
                                    <td><strong>R$ {{ number_format($consignment->items->sum(function($item) { return $item->quantidade_consignada * $item->valor_unitario; }), 2, ',', '.') }}</strong></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
            
            <div class="row mt-5">
                <div class="col-lg-12 text-right">
                    <button type="submit" class="btn btn-primary">
                        <i class="la la-save"></i>
                        Salvar Alterações
                    </button>
                    <a href="{{ route('consignments.finalize', $consignment->id) }}" class="btn btn-success ml-2">
                        <i class="la la-check-square"></i>
                        Finalizar Consignação
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

@endsection
