<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConsignmentItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'consignment_id',
        'produto_id',
        'produto_variacao_id',
        'quantidade_consignada',
        'quantidade_devolvida',
        'quantidade_vendida',
        'valor_unitario'
    ];

    public function consignment()
    {
        return $this->belongsTo(Consignment::class, 'consignment_id');
    }

    public function produto()
    {
        return $this->belongsTo(Produto::class, 'produto_id');
    }

    public function produtoVariacao()
    {
        return $this->belongsTo(ProdutoVariacao::class, 'produto_variacao_id');
    }

    public function getValorTotalAttribute()
    {
        return $this->quantidade_vendida * $this->valor_unitario;
    }

    public function getQuantidadePendenteAttribute()
    {
        return $this->quantidade_consignada - $this->quantidade_devolvida - $this->quantidade_vendida;
    }

    public function getNomeCompleteAttribute()
    {
        if ($this->produto_variacao_id) {
            return $this->produto->nome . ' - ' . $this->produtoVariacao->descricao;
        }
        
        return $this->produto->nome;
    }
}
