@extends('layouts.app', ['title' => 'Detalhes da Consignação'])
@section('content')

<div class="card card-custom gutter-b">
    <div class="card-header flex-wrap border-0 pt-6 pb-0">
        <div class="card-title">
            <h3 class="card-label">
                {{ $titulo }}
                <small>Consignação #{{ $consignment->id }}</small>
            </h3>
        </div>
        <div class="card-toolbar">
            <a href="{{ route('consignments.index') }}" class="btn btn-secondary">
                <i class="la la-angle-left"></i>Voltar
            </a>
            @if($consignment->status == 'aberto')
            <a href="{{ route('consignments.finalize', $consignment->id) }}" class="btn btn-success ml-2">
                <i class="la la-check-square"></i>Finalizar
            </a>
            <button type="button" class="btn btn-danger ml-2" data-toggle="modal" data-target="#cancelModal">
                <i class="la la-times-circle"></i>Cancelar
            </button>
            @endif
        </div>
    </div>

    <div class="card-body">
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-12">
                <div class="form-group row">
                    <label class="col-4 col-form-label font-weight-bold">Cliente:</label>
                    <div class="col-8">
                        <span class="form-control-plaintext">{{ $consignment->cliente->razao_social }}</span>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-4 col-form-label font-weight-bold">Telefone:</label>
                    <div class="col-8">
                        <span class="form-control-plaintext">{{ $consignment->cliente->telefone ?? '-' }}</span>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-4 col-form-label font-weight-bold">Email:</label>
                    <div class="col-8">
                        <span class="form-control-plaintext">{{ $consignment->cliente->email ?? '-' }}</span>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-12">
                <div class="form-group row">
                    <label class="col-4 col-form-label font-weight-bold">Status:</label>
                    <div class="col-8">
                        <span class="label label-{{ $consignment->status_class }} label-lg">
                            {{ $consignment->status_texto }}
                        </span>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-4 col-form-label font-weight-bold">Data Abertura:</label>
                    <div class="col-8">
                        <span class="form-control-plaintext">{{ \Carbon\Carbon::parse($consignment->data_abertura)->format('d/m/Y') }}</span>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-4 col-form-label font-weight-bold">Data Fechamento:</label>
                    <div class="col-8">
                        <span class="form-control-plaintext">
                            @if($consignment->data_fechamento)
                                {{ \Carbon\Carbon::parse($consignment->data_fechamento)->format('d/m/Y') }}
                            @else
                                -
                            @endif
                        </span>
                    </div>
                </div>
            </div>
        </div>
        
        @if($consignment->observacao)
        <div class="row">
            <div class="col-12">
                <div class="form-group">
                    <label class="font-weight-bold">Observação:</label>
                    <p>{{ $consignment->observacao }}</p>
                </div>
            </div>
        </div>
        @endif
        
        <div class="separator separator-dashed my-5"></div>
        
        <div class="row mb-5">
            <div class="col-lg-12">
                <h4>Produtos Consignados</h4>
            </div>
        </div>
        
        <div class="row">
            <div class="col-lg-12">
                <div class="table-responsive">
                    <table class="table table-hover table-striped">
                        <thead>
                            <tr>
                                <th>Produto</th>
                                <th>Valor Unitário</th>
                                <th>Qtd. Consignada</th>
                                <th>Qtd. Devolvida</th>
                                <th>Qtd. Vendida</th>
                                <th>Subtotal</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($consignment->items as $item)
                            <tr>
                                <td>
                                    {{ $item->produto->nome }}
                                    @if($item->produtoVariacao)
                                        - {{ $item->produtoVariacao->descricao }}
                                    @endif
                                </td>
                                <td>R$ {{ number_format($item->valor_unitario, 2, ',', '.') }}</td>
                                <td>{{ number_format($item->quantidade_consignada, 3, ',', '.') }}</td>
                                <td>{{ number_format($item->quantidade_devolvida, 3, ',', '.') }}</td>
                                <td>{{ number_format($item->quantidade_vendida, 3, ',', '.') }}</td>
                                <td>R$ {{ number_format($item->valor_total, 2, ',', '.') }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="5" class="text-right"><strong>Total:</strong></td>
                                <td><strong>R$ {{ number_format($consignment->valor_total, 2, ',', '.') }}</strong></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Cancelamento -->
<div class="modal fade" id="cancelModal" tabindex="-1" role="dialog" aria-labelledby="cancelModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cancelModalLabel">Cancelar Consignação</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i aria-hidden="true" class="ki ki-close"></i>
                </button>
            </div>
            <div class="modal-body">
                <p>Tem certeza que deseja cancelar esta consignação?</p>
                <p>Esta ação irá devolver todos os produtos ao estoque e não poderá ser desfeita.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                <form action="{{ route('consignments.cancel', $consignment->id) }}" method="POST">
                    @csrf
                    <button type="submit" class="btn btn-danger">Confirmar Cancelamento</button>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection
