<?php

namespace App\Services;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;

class PayMundiService
{
    private $url_base;
    private $public_key;
    private $secret_key;

    public function __construct($publicKey, $secretKey)
    {
        $this->url_base = env('PAYMUNDI_URL_BASE', 'https://app.paymundi.com.br/api/v2');
        $this->public_key = $publicKey;
        $this->secret_key = $secretKey;
    }

    public function gerarPix($data)
    {
        try {
            $client = $this->guzzle();
            $body = [
                "type" => "PIX",
                "identifier" => uniqid(),
                "details" => $data['titulo'],
                "nickname_connection" => "ERP-98",
                "public_key" => $this->public_key,
                "secret_key" => $this->secret_key,
                "name_documentor" => $data['cliente'],
                "documentor" => preg_replace('/\D/', '', $data['cpf_cnpj']),
                "payment" => [
                    "currency" => "BRL",
                    "amount" => floatval($data['valor'])
                ],
                "theme" => [
                    "checkout_theme" => "dark",
                    "site_logo" => secure_url('/') . "/logo.png"
                ]
            ];

            $response = $client->post($this->url_base . '/gateway/pay/init', [
                'json' => $body
            ]);

            return json_decode($response->getBody()->getContents(), true);
        } catch (\Throwable $th) {
            return $this->handleException($th);
        }
    }

    public function getPix($data)
    {
        try {
            $client = $this->guzzle();
            $body = [
                "trxid" => $data['trxid'],
                "endToEndId" => $data['endToEndId'],
                "public_key" => $this->public_key,
                "secret_key" => $this->secret_key,
            ];

            $response = $client->post($this->url_base . '/get-pix', [
                'json' => $body
            ]);

            return json_decode($response->getBody()->getContents(), true);
        } catch (\Throwable $th) {
            return $this->handleException($th);
        }
    }

    public function guzzle()
    {
        $client = new Client();
        return $client;
    }

    private function handleException($e)
    {
        try {
            if (@$e) {
                if (@$e instanceof \GuzzleHttp\Exception\RequestException) {
                    if ($e->hasResponse()) {
                        $responseBody = $e->getResponse()->getBody()->getContents();
                        Log::info("Service PayMundi ERROR: " . $responseBody);
                    } else {
                        Log::info("Service PayMundi ERROR: " . $e->getMessage());
                    }
                } else {
                    Log::info("Service PayMundi ERROR: " . $e->getMessage());
                }
            }
            return false;
        } catch (\Throwable $th) {
            Log::error("Service PayMundi handleException ERROR");
            return false;
        }
    }
}
